/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws.base.wsrr;

import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWWSRRRegistry;
import filenet.vw.base.logging.Logger;
import filenet.ws.api.wsrr.WSWSRRRegistry;
import filenet.ws.utils.WSValidateServerCertificate;
import filenet.ws.utils.jsse.WSJSSE;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VWWSRRRegistryItem {
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_CONNECTED = 1;
    public static final int STATE_UNREACHABLE = 2;
    private boolean m_bPublish = false;
    private String m_username = null;
    private String m_password = null;
    private WSWSRRRegistry m_wsWSRRRegistry = null;
    private VWWSRRRegistry m_vwWSRRRegistry = null;
    private boolean m_bNeedRefreshServices = true;
    private int m_registryState = 0;
    protected static Logger logger = Logger.getLogger("filenet.vw.toolkit.utils.ws");
    private Vector m_changeListeners = new Vector();

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 09:16:02  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.10  $";
    }

    public VWWSRRRegistryItem(VWSession session, String host, String port, String username, String password, boolean bPublish) throws VWException {
        try {
            if (port != null && port.compareTo("") == 0) {
                this.m_wsWSRRRegistry = WSWSRRRegistry.newWSRRRegistry(session, host);
            } else {
                int iPort = new Integer(port);
                this.m_wsWSRRRegistry = WSWSRRRegistry.newWSRRRegistry(session, host, iPort);
            }
            this.m_username = username;
            this.m_password = password;
            this.m_wsWSRRRegistry.setQueryUsernamePassword(this.m_username, this.m_password);
            this.m_wsWSRRRegistry.setPublishUsernamePassword(this.m_username, this.m_password);
        }
        catch (NumberFormatException ex) {
            throw new VWException(ex);
        }
        catch (VWException ex) {
            throw ex;
        }
        this.m_bPublish = bPublish;
        this.m_bNeedRefreshServices = true;
    }

    public VWWSRRRegistryItem(VWSession session, VWWSRRRegistry wsrrRegistry) throws VWException {
        this(session, wsrrRegistry.getServerName(), wsrrRegistry.getPort(), wsrrRegistry.getUserName(), wsrrRegistry.getPassword(), wsrrRegistry.getPublish());
        this.m_vwWSRRRegistry = wsrrRegistry;
        this.m_bNeedRefreshServices = true;
    }

    public synchronized void addChangeListener(ChangeListener listener) {
        if (!this.m_changeListeners.contains(listener)) {
            this.m_changeListeners.add(listener);
        }
    }

    public synchronized void removeItemListener(ItemListener listener) {
        if (this.m_changeListeners.contains(listener)) {
            this.m_changeListeners.remove(listener);
        }
    }

    public WSWSRRRegistry getWSWSRRRegistry() {
        return this.m_wsWSRRRegistry;
    }

    public VWWSRRRegistry getVWWSRRRegistry() {
        return this.m_vwWSRRRegistry;
    }

    public String getHostName() {
        if (this.m_wsWSRRRegistry != null) {
            return this.m_wsWSRRRegistry.getRegisteryHostName();
        }
        return null;
    }

    public String toString() {
        return this.getHostName();
    }

    public String getWSRRURL() {
        if (this.m_wsWSRRRegistry != null) {
            return this.m_wsWSRRRegistry.getRegistryURL();
        }
        return null;
    }

    public boolean getPublish() {
        return this.m_bPublish;
    }

    public boolean hasQueryCredential() throws Exception {
        boolean bHasQueryCrendital = false;
        if (this.m_wsWSRRRegistry != null) {
            bHasQueryCrendital = this.m_wsWSRRRegistry.hasQueryCredential();
        }
        return bHasQueryCrendital;
    }

    public boolean isAuthenticated() throws Exception {
        boolean bAuthenticated = false;
        if (this.m_wsWSRRRegistry != null) {
            bAuthenticated = this.m_wsWSRRRegistry.validateUser(this.m_username, this.m_password);
        }
        return bAuthenticated;
    }

    public boolean setUserInfo(String name, String password) {
        try {
            if (this.m_wsWSRRRegistry != null) {
                this.m_wsWSRRRegistry.setQueryUsernamePassword(name, password);
                this.m_wsWSRRRegistry.setPublishUsernamePassword(name, password);
                this.m_username = name;
                this.m_password = password;
                return this.isAuthenticated();
            }
        }
        catch (Exception ex) {
            return false;
        }
        return false;
    }

    public boolean getNeedRefreshServices() {
        return this.m_bNeedRefreshServices;
    }

    public void setNeedRefreshServices(boolean bNeedRefresh) {
        this.m_bNeedRefreshServices = bNeedRefresh;
    }

    public boolean validateCert() throws Exception {
        String[] urls = new String[]{this.getWSRRURL()};
        boolean[] validated = new boolean[]{false};
        WSValidateServerCertificate validateCert = new WSValidateServerCertificate();
        validated = validateCert.validateServers(urls);
        Exception[] exceptions = validateCert.getValidateServerExceptions();
        if (exceptions != null && exceptions.length > 0 && exceptions[0] != null) {
            this.m_registryState = 2;
            throw exceptions[0];
        }
        if (validated[0]) {
            this.m_registryState = 1;
        }
        return validated[0];
    }

    public void refresh() throws Exception {
        if (this.m_registryState == 1) {
            try {
                this.m_bNeedRefreshServices = true;
                if (this.m_changeListeners != null) {
                    for (int i = 0; i < this.m_changeListeners.size(); ++i) {
                        ((ChangeListener)this.m_changeListeners.get(i)).stateChanged(new ChangeEvent(this));
                    }
                }
            }
            catch (Exception ex) {
                this.m_registryState = 2;
                throw ex;
            }
        }
    }

    public int getState() {
        return this.m_registryState;
    }

    public void setState(int state) {
        this.m_registryState = state;
    }

    public boolean isConnected() throws Exception {
        try {
            boolean bConnected = this.m_wsWSRRRegistry.isConnected();
            this.m_registryState = bConnected ? 1 : 2;
        }
        catch (Exception ex) {
            this.m_registryState = 2;
            throw ex;
        }
        return this.m_registryState == 1;
    }

    static {
        try {
            WSJSSE.installAxisJSSESocketFactory(null);
        }
        catch (Exception ex) {
            logger.throwing("VWWSRRRegistryItem", "filenet.ws.utils.jsse.WSJSSE.installAxisJSSESocketFactory", ex);
        }
    }
}

